#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:37:27 
# _clone-sadms.sh

### P A R A M S

MYREMOTEHOST="$1"
MYREMOTEUSER="$2"
MYREMOTEDIR="$3"
MYLOCALDIR="$4"
if [ "${MYREMOTEHOST}" == "" ]; then
	echo "no remote host" >&2
fi
[ "${MYREMOTEUSER}" != "" ] || MYREMOTEUSER="root"
[ "${MYREMOTEDIR}" != "" ] || MYREMOTEDIR="/opt/sadms"
[ "${MYLOCALDIR}" != "" ] || MYLOCALDIR=`pwd`

### I N C L U D E

. ./_include.sh

### S T A R T

echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "clone"
echo "${MYREMOTEHOST}:${MYREMOTEDIR}"
echo "-------------------------------------------------------------------------------"

echo "+mkdir ${MYREMOTEDIR}"
ssh -T -l ${MYREMOTEUSER} ${MYREMOTEHOST} "[ -d ${MYREMOTEDIR} ] || mkdir -p ${MYREMOTEDIR}";

echo "+copy ${MYLOCALDIR} to ${MYREMOTEHOST}:${MYREMOTEDIR}"
scp -pr ${MYLOCALDIR}/* ${MYREMOTEUSER}@${MYREMOTEHOST}:${MYREMOTEDIR}
echo "+end"
