# coding=UTF8
#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2009 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""
Unit tests for schooltool.intervention.generations.evolve6
"""

import unittest
import doctest

from zope.app.testing import setup
from zope.component.hooks import setSite
from zope.container.btree import BTreeContainer
from zope.interface import implements
from zope.site.folder import Folder

from schooltool.app.interfaces import ISchoolToolApplication
from schooltool.generations.tests import ContextStub
from schooltool.generations.tests import setUp, tearDown
from schooltool.intervention.generations.evolve6 import evolve


class AppStub(Folder):
    implements(ISchoolToolApplication)


def doctest_evolve6():
    """Evolution to generation 6.

    First, we'll set up the app object:

        >>> context = ContextStub(app)

    We'll set up our test with data that will be effected by running the
    evolve script:

        >>> app[u'schooltool.schoolyear'] = BTreeContainer()
        >>> app[u'schooltool.schoolyear'][u'2009'] = BTreeContainer()
        >>> root = app[u'schooltool.interventions'] = BTreeContainer()
        >>> root['2008'] = BTreeContainer()
        >>> root['2009'] = BTreeContainer()

    Finally, we'll run the evolve script, testing the effected values before and
    after:

        >>> sorted(root.keys())
        [u'2008', u'2009']

        >>> evolve(context)

        >>> sorted(root.keys())
        [u'2009']

    What if the intervention container doesn't exist yet in the
    application:

        >>> del app[u'schooltool.interventions']
        >>> context = ContextStub(app)
        >>> evolve(context)

    """


def test_suite():
    return unittest.TestSuite([
        doctest.DocTestSuite(setUp=setUp, tearDown=tearDown,
                             optionflags=doctest.ELLIPSIS
                             | doctest.NORMALIZE_WHITESPACE
                             | doctest.REPORT_NDIFF
                             | doctest.REPORT_ONLY_FIRST_FAILURE),
        ])

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
