/* Public domain. */

#include "uint32.h"
#include "uint64.h"
#include "biguint.h"

void bu_mul (uint32 *x, uint32 const *a, unsigned int an, uint32 const *b, unsigned int bn)
{
  uint32 c[BIGUINT_MAXLIMBS] ;
  unsigned int alen = bu_len(a, an) ;
  unsigned int blen = bu_len(b, bn) ;
  register unsigned int i = 0 ;
  bu_zero(c, an+bn) ;
  for (; i < alen ; i++)
  {
    register unsigned int j = 0 ;
    register uint32 carry = 0 ;
    for (; j < blen ; j++)
    {
      register uint64 t = a[i] ;
      t *= b[j] ;
      t += c[i+j] ;
      t += carry ;
      c[i+j] = (uint32)t ;
      carry = (uint32)(t >> 32) ;
    }
    c[i + blen] = carry ;
  }
  bu_copy(x, c, an+bn) ;
}
