5.1 Blocks

# Blocks

Eine Struktur, die man häufig in Sonic Pi sieht, ist der Block. Blocks 
erlauben uns, nützliche Dinge mit größeren Codeabschnitten zu tun. Mit 
Synth- oder Sample-Parametern konnten wir etwas ändern, was in einer 
Codezeile geschah. Manchmal aber möchten wir etwas mit einer ganzen 
Reihe von Codezeilen anstellen. Zum Beispiel möchten wir diese in einer 
Schleife ablaufen lassen, Hall hinzufügen, bei vorgegebenen 
Wiederholungen nur eine von fünf ablaufen lassen etc. Schau Dir den 
folgenden Code an:

```
play 50
sleep 0.5
sample :elec_plip
sleep 0.5
play 62
```

Um etwas mit einem mehrzeiligen Codestück zu tun, müssen wir Sonic Pi 
sagen, wo der Code-Block *anfängt*, und wo er *aufhört*. Dazu verwenden 
wir `do` für den Anfang und `end` für das Ende. So zum Beispiel:

```
do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Das ist aber noch nicht alles und wird so nicht funktionieren (versuche 
es und Du wirst einen Fehler erhalten), weil wir Sonic Pi noch nicht 
gesagt haben, was wir mit diesem *do/end-Block* machen wollen. Dafür 
setzen wir noch einen speziellen Ausdruck vor das `do`. Solche 
Ausdrücke werden wir in diesem Tutorial gleich kennenlernen. Zunächst 
einmal ist wichtig, dass wir mehrere Codezeilen mit `do` und `end` 
zusammenfassen und Sonic Pi sagen können, dass wir mit diesem Codestück 
etwas Bestimmtes machen wollen.
