6.1 Dodawanie Efektów

# Dodawanie Efektów

W tej sekcji przyjrzymy się kilku efektom (FX): reverb i echo. Zobaczymy 
w jaki sposób ich używać, w jaki sposób kontrolować ich parametry oraz 
jak łączyć je ze sobą w jeden łańcuch. 

System efektów w Sonic Pi korzysta z bloków kodu. Jeśli więc do tej pory 
nie przeczytałeś jeszcze sekcji 5.1, to teraz jest dobry moment by nadrobić 
zaległości.

## Efekt Reverb

Jeśli chcemy użyć efektu reverb wystarczy, że napiszemy `with_fx :reverb` 
jako specjalny kawałek kodu dla naszego bloku do/end:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

A teraz uruchom ten kod a usłyszysz jak jest zagrany z nałożonym 
na niego efektem reverb. Brzmi nieźle, prawda?! Wszystko brzmi całkiem 
fajnie z efektem reverb.

A teraz zobaczmy co się wydarzy, gdy umieścimy jakiś dodatkowy kod poza 
naszym blokiem do/end:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

Zauważ, że ostania linia `play 55` nie jest zagrana z efektem reverb. 
Dzieje się tak ponieważ znajduje się *poza blokiem* kodu do/end, więc 
dzięki temu nie jest objęta efektem reverb.

Analogicznie, jeśli zrobisz jakieś dźwięki przed blokiem do/end, to 
one również nie będą pod wpływem efektu reverb:

```
play 55
sleep 1

with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

## Efekt Echo

Jest wiele efektów do wyboru. Co powiesz na echo?

```
with_fx :echo do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Jednym z potężnych aspektów bloków efektów w Sonic Pi jest to, że można 
do nich przekazywać parametry podobne do parametrów, które już widzieliśmy 
gdy korzystaliśmy z poleceń `play` i `sample`. Na przykład bardzo fajnym 
parametrem, który nieźle brzmi z efektem echo jest `phase:`. Reprezentuje 
on czas trwania danego efektu przez określoną liczbę uderzeń (ile uderzeń trwa efekt). 
Spróbujmy sprawić aby efekt echo był trochę wolniejszy: 

```
with_fx :echo, phase: 0.5 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Spróbujmy też sprawić aby echo brzmiało szybciej:

```
with_fx :echo, phase: 0.125 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Sprawmy teraz aby zanikanie echa trwało dłużej ustawiając parametr 
`decay` na 8 sekund:

```
with_fx :echo, phase: 0.5, decay: 8 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

## Zagnieżdżanie Efektów

Jednym z najbardziej potężnych aspektów bloków zawierających efekty 
jest to, że możesz je zagnieżdzać. Pozwala to na bardzo łatwe łączenie 
ich razem. Na przykład, co jeśli chciałeś zagrać kawałek jakiegoś kodu 
z efektami echo i reverb? Łatwizna, po prostu umieść jeden w drugim: 

```
with_fx :reverb do
  with_fx :echo, phase: 0.5, decay: 8 do
    play 50
    sleep 0.5
    sample :elec_blup
    sleep 0.5
    play 62
  end
end
```

Pomyśl o przepływie dźwięku ze środka na zewnątrz. Dźwięk z najbardziej 
wewnętrznego bloku kodu, np. `play 50` jest najpierw wysyłany do 
efektu echo, następnie dźwięk z nałożonym echo jest z kolei wysyłany 
do efektu reverb. 

Możemy używać wielu takich zagnieżdżeń dlo osiągania zwariowanych 
wyników. Jednakże uważaj, efekty mogą zużywać sporo zasobów. Zagnieżdżając 
jeden w drugim uruchamiasz wiele efektów na raz. Bądź więc oszczędny 
z ich używaniem, zwłaszcza na platformach o słabych parametrach 
(procesor, pamięć, itd.) na przykład takich jak Raspberry Pi.

## Odkrywanie Efektów

Sonic Pi posiada wiele wbudowanych efektów, z których możesz korzystać. 
Aby zobaczyć jakie z nich są dostępne, kliknij na ikonie *Fx* (efekty) 
w sekcji pomocy a zobaczysz listę wszystkich dostępnych opcji. Oto 
kilka moich ulubionych: 

* wobble,
* reverb,
* echo,
* distortion,
* slicer

A teraz powariuj trochę i dodaj efektów wszędzie gdzie tylko możesz 
aby stworzyć zdumiewające nowe dźwięki!
