/* SRG 1.1 - Default Javascript 
 *
 * If you make modifications to this script you *must* modify the 
 * first line otherwise your changes may be overwritten when SRG is
 * upgraded.
 * 
 */

function extractOrder(order) {
    if (order==1)
        return "descending";
    else
        return "ascending";
}
function extractText(cell) {
    if (cell.hasChildNodes()) {
        return extractText(cell.childNodes[0]);
    } else {
        return cell.nodeValue;
    }
}
function makeHeader(row, celln, ord) {
    var link, cell;
    cell = row.cells[celln];
    cellt = extractText(cell)
    ot = extractOrder(ord)
    link ="<a href=\"javascript:sortTable("+celln+","+ord+");\"" +
        "onmouseover=\"window.status='Sort by "+cellt+" ("+ot +
        ")';return true;\" onmouseout=\"window.status='';" +
        "return true;\">"+cellt+"</a>";
    cell.innerHTML=link;
}
g_table=document.getElementById("srgtable");
g_head_rows=g_table.tHead.rows
g_msgdiv=document.getElementById("srg-message");
if (g_head_rows.length==1) {
    for (i=0;i<g_head_rows[0].cells.length;++i) {
        makeHeader(g_head_rows[0], i, 1);
    }
}
function compareRows(a,b) {
       updateStatus();
	if(a.sortKey==b.sortKey)
		return 0;
	/* Sort numbers first */
	if(a.sortKey.match(/^\d/) && !b.sortKey.match(/^\d/))
		return g_order;
	if(!a.sortKey.match(/^\d/) && b.sortKey.match(/^\d/))
		return -g_order;
	/* Sort numerically */
	if(a.sortKey.match(/^\d/) && b.sortKey.match(/^\d/)) {
		c=a.sortKey.replace(/[^0-9.]/g,"");
		d=b.sortKey.replace(/[^0-9.]/g,"");
		return (parseFloat(c) < parseFloat(d)) ? g_order : -g_order;
	}
	/* Sort by string */
	return (a.sortKey < b.sortKey) ? g_order : -g_order;
}
function updateStatus() {
    var d, et, t;
    d = new Date();
    et = d.getTime()-g_sort_start;
    if ((et%200)==0) {
        t = g_msgdiv.innerHTML + ".";
        g_msgdiv.innerHTML = t;
    }
}
function sortTable(colNo, ord) {
    var table, rows, nR, bs, i, j, temp;
    g_order=ord;
    g_colNo=colNo;
    table=document.getElementById("srgtable")
    g_msgdiv.innerHTML="Sorting table...";
    d = new Date();
    g_sort_start = d.getTime()
    rows=new Array();
    nR=0;
    bs=table.tBodies;
    for(i=0; i<bs.length; ++i) {
        for(j=0; j<bs[i].rows.length; ++j) {
            rows[nR]=bs[i].rows[j];
            temp=rows[nR].cells[g_colNo];
            if(temp) {
                rows[nR].sortKey=temp.innerHTML;
            } else {
                rows[nR].sortKey="";
            }
            ++nR;
        }
    }
    rows.sort(compareRows);
    for (i=0; i < rows.length; ++i) {
        if (i%2==0)
            rows[i].setAttribute("class", "highlightRow");
        else
            rows[i].setAttribute("class", "");
        table.tBodies[0].appendChild(rows[i]);
    }
    makeHeader(g_head_rows[0], colNo, ord<0 ? 1 : -1);
    g_msgdiv.innerHTML="&nbsp;";
}
