#ifndef DPTIMESPARSE_H
#define DPTIMESPARSE_H
#include <fstream>
#include <memory>
#include <functional>
#include <Eigen/Dense>
#include "StOpt/core/grids/SparseSpaceGrid.h"
#include "StOpt/dp/OptimizerDPBase.h"

/* \file DpTimeNonEmissiveSparse.h
 * \brief Defines a simple  program  showing how to optimize a problem by dynamic programming with sparse grids
 *       See Aid, Ren, Touzi :
 *        "Transition to non-emissive electricity production under optimal subsidy and endogenous carbon price"
 * \author Xavier Warin
 */

/// \brief Principal function to optimize  the problem
/// \param p_grid             grid used for  deterministic state (stock)
/// \param p_optimize          optimizer defining the optimisation between two time steps
/// \param p_regressor         regressor object
/// \param p_funcFinalValue    function defining the final value
/// \param p_fileToDump        file to dump continuation values
///
void  DpTimeNonEmissiveSparse(const std::shared_ptr<StOpt::SparseSpaceGrid> &p_grid,
                              const std::shared_ptr<StOpt::OptimizerDPBase > &p_optimize,
                              const std::shared_ptr<StOpt::BaseRegression> &p_regressor,
                              const std::function<double(const int &, const Eigen::ArrayXd &, const Eigen::ArrayXd &)>   &p_funcFinalValue,
                              const std::string   &p_fileToDump);

#endif /* DPTIMENONEMISSIVESPARSE_H */
