/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.org/sumo
// Copyright (C) 2001-2019 German Aerospace Center (DLR) and others.
// This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v2.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v20.html
// SPDX-License-Identifier: EPL-2.0
/****************************************************************************/
/// @file    GUICursors.h
/// @author  Pablo Alvarez Lopez
/// @date    Nov 2018
///
// An enumeration of icons used by the gui applications
/****************************************************************************/
#ifndef GUICursors_h
#define GUICursors_h


// ===========================================================================
// included modules
// ===========================================================================
#include <config.h>


// ===========================================================================
// enumerations
// ===========================================================================
/**
 * @enum GUICursor
 * @brief An enumeration of cursors used by the gui applications
 */
enum GUICursor {
    /// @brief default cursor
    SUMOCURSOR_DEFAULT,

    /// @brief move cursor
    SUMOCURSOR_MOVE,

    /// @brief max number of cursors
    CURSOR_MAX
};


#endif

/****************************************************************************/

