/* valamemberinitializer.c generated by valac, the Vala compiler
 * generated from valamemberinitializer.vala, do not modify */

/* valamemberinitializer.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaMemberInitializerPrivate {
	gchar* _name;
	ValaExpression* _initializer;
};

static gint ValaMemberInitializer_private_offset;
static gpointer vala_member_initializer_parent_class = NULL;

static void vala_member_initializer_set_name (ValaMemberInitializer* self,
                                       const gchar* value);
static void vala_member_initializer_set_initializer (ValaMemberInitializer* self,
                                              ValaExpression* value);
static gboolean vala_member_initializer_real_is_pure (ValaExpression* base);
static void vala_member_initializer_real_accept (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_member_initializer_real_check (ValaCodeNode* base,
                                             ValaCodeContext* context);
static void vala_member_initializer_real_emit (ValaCodeNode* base,
                                        ValaCodeGenerator* codegen);
static void vala_member_initializer_real_get_used_variables (ValaCodeNode* base,
                                                      ValaCollection* collection);
static void vala_member_initializer_real_replace_expression (ValaCodeNode* base,
                                                      ValaExpression* old_node,
                                                      ValaExpression* new_node);
static void vala_member_initializer_finalize (ValaCodeNode * obj);
static GType vala_member_initializer_get_type_once (void);

static inline gpointer
vala_member_initializer_get_instance_private (ValaMemberInitializer* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberInitializer_private_offset);
}

const gchar*
vala_member_initializer_get_name (ValaMemberInitializer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
vala_member_initializer_set_name (ValaMemberInitializer* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

ValaExpression*
vala_member_initializer_get_initializer (ValaMemberInitializer* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_member_initializer_set_initializer (ValaMemberInitializer* self,
                                         ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp0_;
	_tmp1_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new member initializer.
 *
 * @param name             member name
 * @param initializer      initializer expression
 * @param source_reference reference to source code
 * @return                 newly created member initializer
 */
ValaMemberInitializer*
vala_member_initializer_construct (GType object_type,
                                   const gchar* name,
                                   ValaExpression* initializer,
                                   ValaSourceReference* source_reference)
{
	ValaMemberInitializer* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (initializer != NULL, NULL);
	self = (ValaMemberInitializer*) vala_expression_construct (object_type);
	vala_member_initializer_set_initializer (self, initializer);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_initializer_set_name (self, name);
	return self;
}

ValaMemberInitializer*
vala_member_initializer_new (const gchar* name,
                             ValaExpression* initializer,
                             ValaSourceReference* source_reference)
{
	return vala_member_initializer_construct (VALA_TYPE_MEMBER_INITIALIZER, name, initializer, source_reference);
}

static gboolean
vala_member_initializer_real_is_pure (ValaExpression* base)
{
	ValaMemberInitializer * self;
	gboolean result;
	self = (ValaMemberInitializer*) base;
	result = FALSE;
	return result;
}

static void
vala_member_initializer_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}

static gboolean
vala_member_initializer_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context)
{
	ValaMemberInitializer * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaObjectCreationExpression* oce = NULL;
	ValaCodeNode* _tmp4_;
	ValaCodeNode* _tmp5_;
	ValaObjectCreationExpression* _tmp6_;
	ValaDataType* type = NULL;
	ValaObjectCreationExpression* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaTypeSymbol* _tmp13_;
	ValaTypeSymbol* _tmp14_;
	const gchar* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp18_ = FALSE;
	ValaSymbol* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaSymbol* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaSymbolAccessibility _tmp33_;
	ValaSymbolAccessibility _tmp34_;
	ValaDataType* member_type = NULL;
	ValaSymbol* _tmp41_;
	ValaSymbol* _tmp42_;
	ValaExpression* _tmp71_;
	ValaExpression* _tmp72_;
	ValaDataType* _tmp73_;
	ValaExpression* _tmp74_;
	ValaExpression* _tmp75_;
	ValaExpression* _tmp76_;
	ValaExpression* _tmp77_;
	ValaDataType* _tmp78_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaDataType* _tmp81_;
	ValaDataType* _tmp82_;
	ValaExpression* _tmp83_;
	ValaExpression* _tmp84_;
	gboolean _tmp85_ = FALSE;
	ValaExpression* _tmp86_;
	ValaExpression* _tmp87_;
	ValaDataType* _tmp88_;
	ValaDataType* _tmp89_;
	gboolean _tmp101_;
	gboolean _tmp102_;
	gboolean result;
	self = (ValaMemberInitializer*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	oce = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp5_) ? ((ValaObjectCreationExpression*) _tmp5_) : NULL;
	_tmp6_ = oce;
	if (_tmp6_ == NULL) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "internal: Invalid member initializer");
		result = FALSE;
		return result;
	}
	_tmp9_ = oce;
	_tmp10_ = vala_object_creation_expression_get_type_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	type = _tmp11_;
	_tmp12_ = type;
	_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_name;
	_tmp16_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp17_);
	_vala_code_node_unref0 (_tmp17_);
	_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp20_ = _tmp19_;
	if (VALA_IS_FIELD (_tmp20_)) {
		_tmp18_ = TRUE;
	} else {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp22_ = _tmp21_;
		_tmp18_ = VALA_IS_PROPERTY (_tmp22_);
	}
	if (!_tmp18_) {
		ValaSourceReference* _tmp23_;
		ValaSourceReference* _tmp24_;
		const gchar* _tmp25_;
		ValaDataType* _tmp26_;
		ValaTypeSymbol* _tmp27_;
		ValaTypeSymbol* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_name;
		_tmp26_ = type;
		_tmp27_ = vala_data_type_get_type_symbol (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		vala_report_error (_tmp24_, "Invalid member `%s' in `%s'", _tmp25_, _tmp30_);
		_g_free0 (_tmp30_);
		result = FALSE;
		return result;
	}
	_tmp31_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_symbol_get_access (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		ValaSourceReference* _tmp35_;
		ValaSourceReference* _tmp36_;
		ValaSymbol* _tmp37_;
		ValaSymbol* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_symbol_get_full_name (_tmp38_);
		_tmp40_ = _tmp39_;
		vala_report_error (_tmp36_, "Access to private member `%s' denied", _tmp40_);
		_g_free0 (_tmp40_);
		result = FALSE;
		return result;
	}
	member_type = NULL;
	_tmp41_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp42_ = _tmp41_;
	if (VALA_IS_FIELD (_tmp42_)) {
		ValaField* f = NULL;
		ValaSymbol* _tmp43_;
		ValaSymbol* _tmp44_;
		ValaField* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		_tmp43_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp44_ = _tmp43_;
		f = G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_FIELD, ValaField);
		_tmp45_ = f;
		_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = _vala_code_node_ref0 (_tmp47_);
		_vala_code_node_unref0 (member_type);
		member_type = _tmp48_;
	} else {
		ValaSymbol* _tmp49_;
		ValaSymbol* _tmp50_;
		_tmp49_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp50_ = _tmp49_;
		if (VALA_IS_PROPERTY (_tmp50_)) {
			ValaProperty* prop = NULL;
			ValaSymbol* _tmp51_;
			ValaSymbol* _tmp52_;
			ValaProperty* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			ValaDataType* _tmp56_;
			gboolean _tmp57_ = FALSE;
			ValaProperty* _tmp58_;
			ValaPropertyAccessor* _tmp59_;
			ValaPropertyAccessor* _tmp60_;
			_tmp51_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp52_ = _tmp51_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp53_ = prop;
			_tmp54_ = vala_property_get_property_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = _vala_code_node_ref0 (_tmp55_);
			_vala_code_node_unref0 (member_type);
			member_type = _tmp56_;
			_tmp58_ = prop;
			_tmp59_ = vala_property_get_set_accessor (_tmp58_);
			_tmp60_ = _tmp59_;
			if (_tmp60_ == NULL) {
				_tmp57_ = TRUE;
			} else {
				ValaProperty* _tmp61_;
				ValaPropertyAccessor* _tmp62_;
				ValaPropertyAccessor* _tmp63_;
				gboolean _tmp64_;
				gboolean _tmp65_;
				_tmp61_ = prop;
				_tmp62_ = vala_property_get_set_accessor (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_property_accessor_get_writable (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp57_ = !_tmp65_;
			}
			if (_tmp57_) {
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				ValaProperty* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp67_ = _tmp66_;
				_tmp68_ = prop;
				_tmp69_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp68_);
				_tmp70_ = _tmp69_;
				vala_report_error (_tmp67_, "Property `%s' is read-only", _tmp70_);
				_g_free0 (_tmp70_);
				result = FALSE;
				_vala_code_node_unref0 (member_type);
				return result;
			}
		}
	}
	_tmp71_ = vala_member_initializer_get_initializer (self);
	_tmp72_ = _tmp71_;
	_tmp73_ = member_type;
	vala_expression_set_formal_target_type (_tmp72_, _tmp73_);
	_tmp74_ = vala_member_initializer_get_initializer (self);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_member_initializer_get_initializer (self);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_expression_get_formal_target_type (_tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = type;
	_tmp81_ = vala_data_type_get_actual_type (_tmp79_, _tmp80_, NULL, (ValaCodeNode*) self);
	_tmp82_ = _tmp81_;
	vala_expression_set_target_type (_tmp75_, _tmp82_);
	_vala_code_node_unref0 (_tmp82_);
	_tmp83_ = vala_member_initializer_get_initializer (self);
	_tmp84_ = _tmp83_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp84_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member_type);
		return result;
	}
	_tmp86_ = vala_member_initializer_get_initializer (self);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_expression_get_value_type (_tmp87_);
	_tmp89_ = _tmp88_;
	if (_tmp89_ == NULL) {
		_tmp85_ = TRUE;
	} else {
		ValaExpression* _tmp90_;
		ValaExpression* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaExpression* _tmp94_;
		ValaExpression* _tmp95_;
		ValaDataType* _tmp96_;
		ValaDataType* _tmp97_;
		_tmp90_ = vala_member_initializer_get_initializer (self);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_expression_get_value_type (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_member_initializer_get_initializer (self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_expression_get_target_type (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp85_ = !vala_data_type_compatible (_tmp93_, _tmp97_);
	}
	if (_tmp85_) {
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		const gchar* _tmp100_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = self->priv->_name;
		vala_report_error (_tmp99_, "Invalid type for member `%s'", _tmp100_);
		result = FALSE;
		_vala_code_node_unref0 (member_type);
		return result;
	}
	_tmp101_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp102_ = _tmp101_;
	result = !_tmp102_;
	_vala_code_node_unref0 (member_type);
	return result;
}

static void
vala_member_initializer_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
}

static void
vala_member_initializer_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_member_initializer_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node)
{
	ValaMemberInitializer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberInitializer*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_initializer_get_initializer (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_initializer_set_initializer (self, new_node);
	}
}

static void
vala_member_initializer_class_init (ValaMemberInitializerClass * klass,
                                    gpointer klass_data)
{
	vala_member_initializer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_initializer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberInitializer_private_offset);
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_initializer_real_is_pure;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_initializer_real_accept;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_initializer_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_initializer_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_initializer_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_initializer_real_replace_expression;
}

static void
vala_member_initializer_instance_init (ValaMemberInitializer * self,
                                       gpointer klass)
{
	self->priv = vala_member_initializer_get_instance_private (self);
}

static void
vala_member_initializer_finalize (ValaCodeNode * obj)
{
	ValaMemberInitializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
	_g_free0 (self->priv->_name);
	_vala_code_node_unref0 (self->priv->_initializer);
	VALA_CODE_NODE_CLASS (vala_member_initializer_parent_class)->finalize (obj);
}

/**
 * Represents a member initializer, i.e. an element of an object initializer, in
 * the source code.
 */
static GType
vala_member_initializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberInitializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_initializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberInitializer), 0, (GInstanceInitFunc) vala_member_initializer_instance_init, NULL };
	GType vala_member_initializer_type_id;
	vala_member_initializer_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberInitializer", &g_define_type_info, 0);
	ValaMemberInitializer_private_offset = g_type_add_instance_private (vala_member_initializer_type_id, sizeof (ValaMemberInitializerPrivate));
	return vala_member_initializer_type_id;
}

GType
vala_member_initializer_get_type (void)
{
	static volatile gsize vala_member_initializer_type_id__once = 0;
	if (g_once_init_enter (&vala_member_initializer_type_id__once)) {
		GType vala_member_initializer_type_id;
		vala_member_initializer_type_id = vala_member_initializer_get_type_once ();
		g_once_init_leave (&vala_member_initializer_type_id__once, vala_member_initializer_type_id);
	}
	return vala_member_initializer_type_id__once;
}

