# -*- coding: utf-8 -*-

## This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import os
import sys
import subprocess
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from xml.dom import minidom
from xml.dom.minidom import Document
from mplayer import *
from GlobalDefines import *
from snd_editor import *
from DocHelpDlg import *


### Fonctions de conversion :
def positionToSec(position) :
    """Function to convert hh:mm:ss.ms to second.ms"""
    hms = position.split(u":")
    sec = float(hms[0])*3600.0 + float(hms[1])*60 + float(hms[2]) 
    return sec
    
def secondToPos(seconds) :
    """Function to convert second.ms to hh:mm:ss.ms """
    seconds = float(seconds)
    hh = int(seconds/3600)
    mm = int((seconds - hh*3600) / 60)
    ss = seconds - hh*3600 - mm*60
    ssf  = int(ss)
    msf = str(ss-ssf)[2:4]
    pos = u"%02d:%02d:%02d.%s" % (hh, mm, ssf, msf)
    return pos

class SND_Rec(QThread) :
    def __init__(self, VideoporamaInstance) :
      super(SND_Rec, self).__init__()
      self.VideoporamaInstance = VideoporamaInstance      
      self.fileAudioToRec = None
      self.position = u"00:00:00.000"
      self.status = 0
          
    def setFileToRec(self, fileAudio) :
      self.fileAudioToRec = fileAudio
      
    def run(self) :
      self.status = 1
      command = u"\"%ssox\" -d -b 16 -c 2 -e signed-integer -r 44100 -t wav \"%s\" " % (self.VideoporamaInstance.S, unicode(self.fileAudioToRec)) 
      self.process = subprocess.Popen(command.encode('utf-8'), shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, universal_newlines = True) 
      while self.process.poll() == None :
        prog = self.process.stdout.readline()
        if prog.startswith("In") :
          info=prog.split()
          self.position = info[1]

    def rec(self) :
      if self.fileAudioToRec == None : return
      if self.status == 0 :
        self.status = 1 # Record audio file
        self.start()
      else :
        self.process.terminate()
        self.status = 0      
        self.audioLenght = self.position
      

class SoundEditorDlg(QDialog,Ui_SND_editor) :
    def __init__(self, VideoporamaInstance, track=u"Main", parent=None, maxTime=-1):
      super(SoundEditorDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      self.VideoporamaInstance = VideoporamaInstance
      self.maxTime = maxTime
      self.parent = parent
      self.lastDir =  self.VideoporamaInstance.lastDirSound
      self.track = track
      self.stopMAJ = 0
      self.iconRec = QIcon(QPixmap("icons/player_record.png"))
      self.iconStop = QIcon(QPixmap("icons/player_stop.png"))
      # Add mplayer widget at interface
      vbox = QVBoxLayout(self.grpMP)
      self.audioPlayer = Mplayer(self.VideoporamaInstance ,cheminVideo=[""], taille=(300,270), facteurLimitant=Mplayer.LARGEUR,                                 choixWidget=(Mplayer.PAS_PRECEDENT_SUIVANT,Mplayer.CURSEUR_A_PART), cheminMPlayer=self.VideoporamaInstance.MP)
      self.audioPlayer.setAudio(True)
      vbox.addWidget(self.audioPlayer)
      self.audioRecorder = SND_Rec(self.VideoporamaInstance)
      self.SND_record.setDisabled(True)

      self.connect(self.TTstart, SIGNAL("clicked(bool)"), self.setTTstart)
      self.connect(self.Tstart, SIGNAL("clicked(bool)"), self.setTstart)
      self.connect(self.Tend, SIGNAL("clicked(bool)"), self.setTend)
      self.connect(self.TTend, SIGNAL("clicked(bool)"), self.setTTend)
      self.connect(self.breakIn, SIGNAL("valueChanged(double)"), self.breakAction)
      self.connect(self.breakOut, SIGNAL("valueChanged(double)"), self.breakAction)
      self.connect(self.SND_record, SIGNAL("clicked(bool)"), self.recordF)
      self.connect(self.SND_add_file, SIGNAL("clicked(bool)"), self.addSoundFileUrl)
      self.connect(self.SND_type, SIGNAL("currentIndexChanged(int)"), self.changeType)
      self.connect(self.checkSilence, SIGNAL("toggled(bool)"), self.checkSilenceAction)
      self.connect(self.buttonBox, SIGNAL("helpRequested()"), self.helpWin)
      
      
    def helpWin(self) :
      docw=DocHelp(self.VideoporamaInstance,self.VideoporamaInstance.qtapp.translate("Documentation","en-sound-editor.html"),self)
      docw.show()
        

    def breakAction(self) :
      if not self.stopMAJ :
        if self.maxTime != -1 :
          if self.breakOut.value()-self.breakIn.value() > self.maxTime :
            self.breakOut.setValue(self.maxTime + self.breakIn.value())
        if self.breakOut.value() < self.breakIn.value() :
          self.breakOut.setValue(self.breakIn.value())
        self.drawTrim()   

    def recordF(self) :
      if self.SND_type.currentIndex() == 1 :
        self.audioRecorder.rec()
        if self.audioRecorder.status == 0 :
          self.SND_record.setIcon(self.iconRec)
          self.audioPlayer.setFileToPlay(self.SND_file.text())
          self.displayInfo()
        elif self.audioRecorder.status == 1 :
          self.SND_record.setIcon(self.iconStop)

    def setEditorValue(self, urlFile, TstartV, TendV, silenceDuration = 0.0, silence=0, gain=0, fadeIn=0.0, fadeOut=0.0) :
      if silence :
        if self.maxTime != -1 :
          self.maxTime = self.maxTime+silenceDuration
        self.checkSilence.setChecked(silence)
        self.silenceDuration.setValue(silenceDuration)
        self.tabWidget.setCurrentIndex(1)      
      else :
        self.tabWidget.setCurrentIndex(0)
        if urlFile != None :
          self.audioPlayer.setFileToPlay(urlFile)
          self.SND_file.setText(QString(urlFile))
          self.displayInfo()
        self.stopMAJ = 1
        self.breakIn.setValue(TstartV)
        self.breakOut.setValue(TendV)
        self.stopMAJ = 0
        self.gain.setValue(gain)
        self.fadeIn.setValue(fadeIn)
        self.fadeOut.setValue(fadeOut)
        if self.maxTime != -1 :
          self.maxTime = self.maxTime+TendV-TstartV
        self.drawTrim()

    def addSoundFileUrl(self) :
      initFileUrl = self.SND_file.text()
      #Get a new filename
      if self.SND_type.currentIndex() == 0 : # Play existing file
        FileName=QFileDialog.getOpenFileName(self,self.tr("Select audio file"),self.lastDir, QString("audio (*.wav *.ogg *.flac *.mp3 *.mpg *.mp4 *.avi)"))
        if FileName!="":
          self.audioPlayer.setFileToPlay(FileName)
          self.SND_file.setText(QString(FileName))
          self.displayInfo()
      elif self.SND_type.currentIndex() == 1 : # Record new audio file
        FileName=QFileDialog.getSaveFileName(self,self.tr("Define audio file"),self.lastDir, QString("audio (*.wav *.ogg *.flac *.mp3)"))
        if FileName!="":
          self.audioRecorder.setFileToRec(FileName)
          self.SND_file.setText(QString(FileName))
          self.SND_record.setEnabled(True)
      self.lastDir = QFileInfo(FileName).dir().absolutePath()
      self.VideoporamaInstance.lastDirSound = self.lastDir
      if FileName != initFileUrl : self.VideoporamaInstance.App_SetModifiedFlag()
          
    def setTTstart(self) :
      self.stopMAJ=1
      if self.maxTime != -1 :
        if self.breakOut.value() > self.maxTime :
          self.TendV = self.maxTime
      self.breakIn.setValue(0.0)
      self.drawTrim()
      self.VideoporamaInstance.App_SetModifiedFlag()
      self.stopMAJ=0
      
    def setTstart(self) :
      self.stopMAJ=1
      self.breakIn.setValue(self.audioPlayer.temps)
      if self.maxTime != -1 :
        if self.breakOut.value()-self.breakIn.value() > self.maxTime :
          self.breakOut.setValue(self.maxTime + self.breakIn.value())
      if self.breakOut.value() < self.breakIn.value() :
        self.breakOut.setValue(self.breakIn.value())
      self.drawTrim()
      self.VideoporamaInstance.App_SetModifiedFlag()
      self.stopMAJ=0

      
    def setTTend(self) :
      self.stopMAJ=1
      self.breakOut.setValue(self.audioPlayer.dureeVideo)
      if self.maxTime != -1 :
        if self.breakOut.value()-self.breakIn.value() > self.maxTime :
          self.breakOut.setValue(self.maxTime + self.breakIn.value())
      self.drawTrim()
      self.VideoporamaInstance.App_SetModifiedFlag()      
      self.stopMAJ=0
      
    def setTend(self) :
      self.stopMAJ=1    
      self.breakOut.setValue(self.audioPlayer.temps)
      if self.maxTime != -1 :
        if self.breakOut.value()-self.breakIn.value() > self.maxTime :
          self.breakOut.setValue(self.maxTime + self.breakIn.value())
      if self.breakOut.value() < self.breakIn.value() :
        self.breakIn.setValue(self.breakOut.value())
      self.drawTrim()
      self.VideoporamaInstance.App_SetModifiedFlag()
      self.stopMAJ=0
      
    def drawTrim(self) :
      if self.checkSilence.isChecked() : return
      base = QPixmap(300, 25)
      base.fill(Qt.gray)
      compose = QPainter(base)
      compose.setBrush(QBrush(QColor(0,255,0)))
      compose.setPen(QPen(QColor(0,255,0)))
      trimedSound = QRect(self.breakIn.value()/self.audioPlayer.dureeVideo*300.0, 0.0,(self.breakOut.value()-self.breakIn.value())*300.0/self.audioPlayer.dureeVideo ,23.0)
      compose.drawRect(trimedSound)
      compose.setFont(QFont(QString("arial")))
      compose.setPen(QPen(QColor(0,0,0)))
      lenght = secondToPos(self.breakOut.value()-self.breakIn.value())
      compose.drawText(trimedSound.x()+5,20, QString(lenght))
      compose.end()
      self.SND_trim_view.setPixmap(base)
      self.SND_trim_view.setScaledContents(True)
      
      
    def displayInfo(self) :
      if self.checkSilence.isChecked() : return
      self.SND_lenght.setText(QString(secondToPos(self.audioPlayer.dureeVideo)))
      self.SND_SR.setText(QString(str(self.audioPlayer.sampleRate)))
      self.SND_channels.setText(QString(str(self.audioPlayer.channels)))
      self.breakIn.setMaximum(self.audioPlayer.dureeVideo)
      self.breakOut.setMaximum(self.audioPlayer.dureeVideo)
      self.setTTend()
      
    def changeType(self, index) :
      if index == 1 :
        self.audioPlayer.setFileToPlay(QString(u""))
      if index == 0 :
        self.audioRecorder.setFileToRec(None)
        self.SND_record.setDisabled(True)
      self.SND_file.setText(QString(u""))
      self.SND_lenght.setText(QString(u""))
      self.breakIn.setValue(0.0)
      self.breakOut.setValue(0.0)  
      self.VideoporamaInstance.App_SetModifiedFlag()
      
    def checkSilenceAction(self, silence) :
      if silence :
        self.silenceDuration.setEnabled(True)
        if self.maxTime != -1 :
          self.silenceDuration.setMaximum(self.maxTime)
      else :
        self.silenceDuration.setDisabled(True)
      self.cleanUI()
      self.VideoporamaInstance.App_SetModifiedFlag()
        
    def cleanUI (self) :    
        self.audioPlayer.setDisabled(self.checkSilence.isChecked()) 
        self.SND_record.setDisabled(self.checkSilence.isChecked())  
        self.audioPlayer.setFileToPlay(QString(u""))
        self.audioRecorder.setFileToRec(QString(u""))
        self.SND_file.setText(QString(u""))
        self.SND_lenght.setText(QString(u""))
        self.breakIn.setValue(0.0)
        self.breakOut.setValue(0.0)  

    def getAudioObject(self, selected = False) : 
      audioObj = soundObject(self.track, self.SND_file.text(), self.breakIn.value(), self.breakOut.value(), selected, int(self.checkSilence.isChecked()),  self.silenceDuration.value(), self.gain.value(), self.fadeIn.value(), self.fadeOut.value(), self.parent)
      return audioObj

class soundObject(QLabel) :
    """Class to define object audio which compose a sound track. It can be an existing audio file, a recored file or a silence"""
    # Attributes
    track = u"Main" # "Main", "Comment" or "Video" - Type String (unicode)
    urlFile = u"*" 		# URL of sound file.- Type String (unicode) - None value = Silence
    lenght = 0.0 		# time in second of kept part - Type float*
    TstartV = 0.0		# Start point of audio part - Type float, in seconds
    TendV = 0.0		# End point of audio part - Type float, in seconds
    gain = 0				# Gain value in dB (<0 = decrease volume, >0 increase volume)
    silence = 0  		# Is this sound object is a silence ?
    silenceDuration = 0.0  # Silence duration time in second
    fadein = 0.0		# Fade in duration, in seconds 
    fadeout = 0.0		# Fade out duration, in seconds
    trackPosition = 0.0	# Start time of sound track where the sound object begin - Type float, in seconds
    pixmap = None	# Scaled Pixmap of sound object (to display in track) 
    
    def __init__(self, track, urlFile, TstartV, TendV, selected = False, silence=0, silenceDuration=0.0, gain = 0, fadein=0, fadeout=0, parent = None) :
      super(soundObject, self).__init__(parent)
      self.track = track
      if urlFile != u"" : self.urlFile = urlFile
      self.TstartV = TstartV
      self.TendV = TendV
      self.gain = gain
      self.silence = silence
      self.silenceDuration = silenceDuration
      if self.silence :
        self.lenght = self.silenceDuration
      else :
        self.lenght = TendV-TstartV
      self.fadein = fadein
      self.fadeout = fadeout
      self.drawPix(selected)
    
    def drawPix(self, selected = False) :
      """Update scaled pixmap of sound object. 1 sec = 40 pixels"""
      pixmap = QPixmap(int(self.lenght*40), 40)
      if selected :
        if self.silence :
          pixmap.fill(QColor(200,200,0)) 
        else :
          pixmap.fill(Qt.blue)        
      else :
        if self.silence :
          pixmap.fill(Qt.gray)
        else :
          pixmap.fill(Qt.darkGreen)
      compose = QPainter(pixmap)
      compose.setCompositionMode(QPainter.CompositionMode_SourceOver)
      #compose.setPen(QPen(QColor(250,0,0)))
      #compose.setBrush(QBrush(QColor(250,0,0)))
      compose.setFont(QFont(QString("arial"), 8))
      if self.silence :
        compose.setPen(QPen(QColor(200,50,0)))
        compose.drawText(5, 17, QString(u"Silence"))
      else :
        compose.setPen(QPen(QColor(0,250,0)))
        compose.drawText(5, 17, QString(self.urlFile.split(u"/")[-1]))
      compose.drawText(5, 33, QString(secondToPos(self.lenght)))
      compose.end()
      self.setPixmap(pixmap)

    def copy(self) :
      """Create and return a copy as a new object"""
      SO = soundObject(track=self.track, urlFile=self.urlFile, TstartV= self.TstartV, TendV=self.TendV, selected = True, silence=self.silence, silenceDuration=self.silenceDuration, gain = self.gain, fadein=self.fadein , fadeout=self.fadeout, parent = None)
      return SO
      
    def getXMLSoundObject(self, doc) :
      """Function to define XML tag of this sound object"""
      xmlRoot=doc.createElement(u"soundObject")
      xmlRoot.setAttribute(u'track',unicode(self.track))
      xmlRoot.setAttribute(u'urlFile',unicode(self.urlFile))
      xmlRoot.setAttribute(u'TstartV',unicode(self.TstartV))
      xmlRoot.setAttribute(u'TendV',unicode(self.TendV))
      xmlRoot.setAttribute(u'fadein',unicode(self.fadein))
      xmlRoot.setAttribute(u'fadeout',unicode(self.fadeout))
      xmlRoot.setAttribute(u'gain',unicode(self.gain))      
      xmlRoot.setAttribute(u'silence',unicode(int(self.silence)))
      xmlRoot.setAttribute(u'silenceD',unicode(self.silenceDuration))
      
      return xmlRoot
      
    def getPropSoundObject(self) :
      """Function to retrun sound object properties"""
      Root=[unicode(self.track),unicode(self.urlFile),self.TstartV,self.TendV, self.silence, self.silenceDuration, self.gain, self.fadein, self.fadeout]
      return Root
      
class nullSound(QLabel) :
      
    lenght = 0.0 		# time in second of kept part - Type float*
    silence = 0  		# Is this sound object is a silence ?
      
    def __init__(self, duration, parent = None) :
      super(nullSound, self).__init__(parent)
      self.lenght = duration
      pixmap = QPixmap(int(self.lenght*40), 38)
      pixmap.fill(QColor(250,250,128)) 
      self.setPixmap(pixmap)
      
