# Summary

[Getting Started](./getting-started.md)

[About this guide](./about-this-guide.md)

---

# Building and debugging `rustc`

- [How to build and run the compiler](./building/how-to-build-and-run.md)
    - [Quickstart](./building/quickstart.md)
    - [Prerequisites](./building/prerequisites.md)
    - [Suggested workflows](./building/suggested.md)
    - [Distribution artifacts](./building/build-install-distribution-artifacts.md)
    - [Building documentation](./building/compiler-documenting.md)
    - [Rustdoc overview](./rustdoc.md)
    - [Adding a new target](./building/new-target.md)
    - [Optimized build](./building/optimized-build.md)
- [Testing the compiler](./tests/intro.md)
    - [Running tests](./tests/running.md)
        - [Testing with Docker](./tests/docker.md)
        - [Testing with CI](./tests/ci.md)
    - [Adding new tests](./tests/adding.md)
    - [Best practices](./tests/best-practices.md)
    - [Compiletest](./tests/compiletest.md)
        - [UI tests](./tests/ui.md)
        - [Test directives](./tests/directives.md)
        - [Minicore](./tests/minicore.md)
    - [Ecosystem testing](./tests/ecosystem.md)
        - [Crater](./tests/crater.md)
        - [Fuchsia](./tests/ecosystem-test-jobs/fuchsia.md)
        - [Rust for Linux](./tests/ecosystem-test-jobs/rust-for-linux.md)
    - [Codegen backend testing](./tests/codegen-backend-tests/intro.md)
        - [Cranelift codegen backend](./tests/codegen-backend-tests/cg_clif.md)
        - [GCC codegen backend](./tests/codegen-backend-tests/cg_gcc.md)
    - [Performance testing](./tests/perf.md)
    - [Suggest tests tool](./tests/suggest-tests.md)
    - [Misc info](./tests/misc.md)
- [Debugging the compiler](./compiler-debugging.md)
    - [Using the tracing/logging instrumentation](./tracing.md)
- [Profiling the compiler](./profiling.md)
    - [with the linux perf tool](./profiling/with_perf.md)
    - [with Windows Performance Analyzer](./profiling/wpa_profiling.md)
    - [with the Rust benchmark suite](./profiling/with_rustc_perf.md)
- [crates.io dependencies](./crates-io.md)

# Contributing to Rust

- [Contribution procedures](./contributing.md)
- [About the compiler team](./compiler-team.md)
- [Using Git](./git.md)
- [Mastering @rustbot](./rustbot.md)
- [Walkthrough: a typical contribution](./walkthrough.md)
- [Implementing new language features](./implementing_new_features.md)
- [Stability attributes](./stability.md)
- [Stabilizing Features](./stabilization_guide.md)
- [Feature Gates](./feature-gates.md)
- [Coding conventions](./conventions.md)
- [Procedures for breaking changes](./bug-fix-procedure.md)
- [Using external repositories](./external-repos.md)
- [Fuzzing](./fuzzing.md)
- [Notification groups](notification-groups/about.md)
    - [Apple](notification-groups/apple.md)
    - [ARM](notification-groups/arm.md)
    - [Cleanup Crew](notification-groups/cleanup-crew.md)
    - [Emscripten](notification-groups/emscripten.md)
    - [Fuchsia](notification-groups/fuchsia.md)
    - [LLVM](notification-groups/llvm.md)
    - [RISC-V](notification-groups/risc-v.md)
    - [Rust for Linux](notification-groups/rust-for-linux.md)
    - [WASI](notification-groups/wasi.md)
    - [WebAssembly](notification-groups/wasm.md)
    - [Windows](notification-groups/windows.md)
- [Licenses](./licenses.md)
- [Editions](guides/editions.md)

# Bootstrapping

- [Prologue](./building/bootstrapping/intro.md)
- [What Bootstrapping does](./building/bootstrapping/what-bootstrapping-does.md)
- [How Bootstrap does it](./building/bootstrapping/how-bootstrap-does-it.md)
- [Writing tools in Bootstrap](./building/bootstrapping/writing-tools-in-bootstrap.md)
- [Debugging bootstrap](./building/bootstrapping/debugging-bootstrap.md)
- [cfg(bootstrap) in dependencies](./building/bootstrapping/bootstrap-in-dependencies.md)

# High-level Compiler Architecture

- [Prologue](./part-2-intro.md)
- [Overview of the compiler](./overview.md)
- [The compiler source code](./compiler-src.md)
- [Queries: demand-driven compilation](./query.md)
    - [The Query Evaluation Model in detail](./queries/query-evaluation-model-in-detail.md)
    - [Incremental compilation](./queries/incremental-compilation.md)
    - [Incremental compilation in detail](./queries/incremental-compilation-in-detail.md)
    - [Debugging and testing](./incrcomp-debugging.md)
    - [Salsa](./queries/salsa.md)
- [Memory management in rustc](./memory.md)
- [Serialization in rustc](./serialization.md)
- [Parallel compilation](./parallel-rustc.md)
- [Rustdoc internals](./rustdoc-internals.md)
    - [Search](./rustdoc-internals/search.md)
	- [The `rustdoc` test suite](./rustdoc-internals/rustdoc-test-suite.md)
- [Autodiff internals](./autodiff/internals.md)
    - [Installation](./autodiff/installation.md)
    - [How to debug](./autodiff/debugging.md)
    - [Autodiff flags](./autodiff/flags.md)
    - [Current limitations](./autodiff/limitations.md)

# Source Code Representation

- [Prologue](./part-3-intro.md)
- [Syntax and the AST](./syntax-intro.md)
    - [Lexing and parsing](./the-parser.md)
    - [Macro expansion](./macro-expansion.md)
    - [Name resolution](./name-resolution.md)
    - [Attributes](./attributes.md)
    - [`#[test]` implementation](./test-implementation.md)
    - [Panic implementation](./panic-implementation.md)
    - [AST validation](./ast-validation.md)
    - [Feature gate checking](./feature-gate-ck.md)
    - [Lang Items](./lang-items.md)
- [The HIR (High-level IR)](./hir.md)
    - [Lowering AST to HIR](./ast-lowering.md)
    - [Debugging](./hir-debugging.md)
- [The THIR (Typed High-level IR)](./thir.md)
- [The MIR (Mid-level IR)](./mir/index.md)
    - [MIR construction](./mir/construction.md)
    - [MIR visitor and traversal](./mir/visitor.md)
    - [MIR queries and passes: getting the MIR](./mir/passes.md)
- [Inline assembly](./asm.md)

# Supporting Infrastructure

- [Command-line arguments](./cli.md)
- [rustc_driver and rustc_interface](./rustc-driver/intro.md)
    - [Example: Type checking](./rustc-driver/interacting-with-the-ast.md)
    - [Example: Getting diagnostics](./rustc-driver/getting-diagnostics.md)
    - [Remarks on perma-unstable features](./rustc-driver/remarks-on-perma-unstable-features.md)
- [Errors and lints](diagnostics.md)
    - [Diagnostic and subdiagnostic structs](./diagnostics/diagnostic-structs.md)
    - [Translation](./diagnostics/translation.md)
    - [`LintStore`](./diagnostics/lintstore.md)
    - [Error codes](./diagnostics/error-codes.md)
    - [Diagnostic items](./diagnostics/diagnostic-items.md)
    - [`ErrorGuaranteed`](./diagnostics/error-guaranteed.md)

# Analysis

- [Prologue](./part-4-intro.md)
- [Generic parameter definitions](./generic_parameters_summary.md)
    - [`EarlyBinder` and instantiating parameters](./ty_module/early_binder.md)
- [Binders and Higher ranked regions](./ty_module/binders.md)
    - [Instantiating binders](./ty_module/instantiating_binders.md)
- [Early vs Late bound parameters](./early_late_parameters.md)
- [The `ty` module: representing types](./ty.md)
    - [ADTs and Generic Arguments](./ty_module/generic_arguments.md)
    - [Parameter types/consts/regions](./ty_module/param_ty_const_regions.md)
- [`TypeFolder` and `TypeFoldable`](./ty-fold.md)
- [Aliases and Normalization](./normalization.md)
- [Typing/Param Envs](./typing_parameter_envs.md)
- [Type inference](./type-inference.md)
- [Trait solving](./traits/resolution.md)
    - [Higher-ranked trait bounds](./traits/hrtb.md)
    - [Caching subtleties](./traits/caching.md)
    - [Implied bounds](./traits/implied-bounds.md)
    - [Specialization](./traits/specialization.md)
    - [Chalk-based trait solving](./traits/chalk.md)
        - [Lowering to logic](./traits/lowering-to-logic.md)
        - [Goals and clauses](./traits/goals-and-clauses.md)
        - [Canonical queries](./traits/canonical-queries.md)
        - [Canonicalization](./traits/canonicalization.md)
    - [Next-gen trait solving](./solve/trait-solving.md)
        - [Invariants of the type system](./solve/invariants.md)
        - [The solver](./solve/the-solver.md)
        - [Canonicalization](./solve/canonicalization.md)
        - [Coinduction](./solve/coinduction.md)
        - [Caching](./solve/caching.md)
        - [Proof trees](./solve/proof-trees.md)
        - [Opaque types](./solve/opaque-types.md)
        - [Significant changes and quirks](./solve/significant-changes.md)
    - [`Unsize` and `CoerceUnsized` traits](./traits/unsize.md)
- [Type checking](./type-checking.md)
    - [Method Lookup](./method-lookup.md)
    - [Variance](./variance.md)
    - [Coherence checking](./coherence.md)
    - [Opaque types](./opaque-types-type-alias-impl-trait.md)
        - [Inference details](./opaque-types-impl-trait-inference.md)
        - [Return Position Impl Trait In Trait](./return-position-impl-trait-in-trait.md)
        - [Region inference restrictions][opaque-infer]
- [Const condition checking](./effects.md)
- [Pattern and Exhaustiveness Checking](./pat-exhaustive-checking.md)
- [Unsafety checking](./unsafety-checking.md)
- [MIR dataflow](./mir/dataflow.md)
- [Drop elaboration](./mir/drop-elaboration.md)
- [The borrow checker](./borrow_check.md)
    - [Tracking moves and initialization](./borrow_check/moves_and_initialization.md)
        - [Move paths](./borrow_check/moves_and_initialization/move_paths.md)
    - [MIR type checker](./borrow_check/type_check.md)
    - [Drop check](./borrow_check/drop_check.md)
    - [Region inference](./borrow_check/region_inference.md)
        - [Constraint propagation](./borrow_check/region_inference/constraint_propagation.md)
        - [Lifetime parameters](./borrow_check/region_inference/lifetime_parameters.md)
        - [Member constraints](./borrow_check/region_inference/member_constraints.md)
        - [Placeholders and universes][pau]
        - [Closure constraints](./borrow_check/region_inference/closure_constraints.md)
        - [Error reporting](./borrow_check/region_inference/error_reporting.md)
    - [Two-phase-borrows](./borrow_check/two_phase_borrows.md)
- [Closure capture inference](./closure.md)
- [Async closures/"coroutine-closures"](coroutine-closures.md)

# MIR to Binaries

- [Prologue](./part-5-intro.md)
- [MIR optimizations](./mir/optimizations.md)
- [Debugging MIR](./mir/debugging.md)
- [Constant evaluation](./const-eval.md)
    - [Interpreter](./const-eval/interpret.md)
- [Monomorphization](./backend/monomorph.md)
- [Lowering MIR](./backend/lowering-mir.md)
- [Code Generation](./backend/codegen.md)
    - [Updating LLVM](./backend/updating-llvm.md)
    - [Debugging LLVM](./backend/debugging.md)
    - [Backend Agnostic Codegen](./backend/backend-agnostic.md)
    - [Implicit Caller Location](./backend/implicit-caller-location.md)
- [Libraries and Metadata](./backend/libs-and-metadata.md)
- [Profile-guided Optimization](./profile-guided-optimization.md)
- [LLVM Source-Based Code Coverage](./llvm-coverage-instrumentation.md)
- [Sanitizers Support](./sanitizers.md)
- [Debugging support in the Rust compiler](./debugging-support-in-rustc.md)

---

[Appendix A: Background topics](./appendix/background.md)

[Appendix B: Glossary](./appendix/glossary.md)

[Appendix C: Code Index](./appendix/code-index.md)

[Appendix D: Compiler Lecture Series](./appendix/compiler-lecture.md)

[Appendix E: Bibliography](./appendix/bibliography.md)

[Appendix Z: HumorRust](./appendix/humorust.md)

---

[pau]: ./borrow_check/region_inference/placeholders_and_universes.md
[opaque-infer]: ./borrow_check/opaque-types-region-inference-restrictions.md
