#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Bad Mojo
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250807.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='bad-mojo'
GAME_NAME='Bad Mojo'

ARCHIVE_BASE_0_NAME='setup_badmojo_2.0.0.3.exe'
ARCHIVE_BASE_0_MD5='aedcb9e57bf5c6e692b889d3c21c4d12'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='770000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.3'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/bad_mojo_redux'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
badmojo.exe
qthook.dll
waveout.dll'
## This configuration file is created by the current game script.
CONTENT_GAME0_BIN_FILES='
badmojo.ini'
CONTENT_GAME1_BIN_PATH='tmp'
CONTENT_GAME1_BIN_FILES='
quicktimeinstaller.exe'
CONTENT_GAME_DATA_FILES='
backgnd
btc
cel
extras
mash
movie
over
palette
qtsystem
roachd
save
scribble
script
sound
topo
quicktime.qts'

USER_PERSISTENT_DIRECTORIES='
save'
USER_PERSISTENT_FILES='
badmojo.ini'

APP_MAIN_EXE='badmojo.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Create required configuration file.
	game_id=$(game_id)
	cat > 'badmojo.ini' <<- EOF
	[booger]
	BACKGROUND=C:\\${game_id}\\OVER;C:\\${game_id}\\BACKGND
	TOPO=C:\\${game_id}\\TOPO
	BTC=C:\\${game_id}\\BTC
	PALETTE=C:\\${game_id}\\PALETTE
	SCRIBBLE=C:\\${game_id}\\OVER;C:\\${game_id}\\SCRIBBLE
	CEL=C:\\${game_id}\\OVER;C:\\${game_id}\\CEL
	SCRIPT=C:\\${game_id}\\SCRIPT
	ROACH=C:\\${game_id}\\ROACHD
	MOVIE=C:\\${game_id}\\OVER;C:\\${game_id}\\MOVIE
	MASH=C:\\${game_id}\\OVER;C:\\${game_id}\\MASH
	SOUND=C:\\${game_id}\\SOUND
	SAVE=C:\\${game_id}\\SAVE
	[SoundMix]
	SoundOn=1
	BetweenScreens=1
	SmallChunkSize=3
	BigChunkSize=26
	BigChunkMethod=0
	DumbSound=0
	[badmojo]
	Preferences=1111110
	EOF
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Install the shipped QuickTime player.
wineprefix_init_custom() {
	cat <<- 'EOF'
	    ## Install the shipped QuickTime player.
	    wine C:\\bad-mojo\\quicktimeinstaller.exe
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
