// Copyright (C) 1999-2015
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fvcontour_h__
#define __fvcontour_h__

#include "vector.h"
#include "contour.h"
#include "frscale.h"
#include "inversescale.h"

class FVContour : public Contour {
 public:
  enum Method {SMOOTH, BLOCK};

 private:
  enum {top, right, bottom, left, none};

  Method method_;
  char* level_;
  int numLevel_;
  int smooth_;
  FrScale::ColorScaleType colorScaleType_;
  float expo_;
  float clipMode_;
  Vector limits_;

  InverseScale* scale;

  void unity(FitsImage*);
  void bin(FitsImage*);
  void nobin(FitsImage*);
  void convolve(FitsImage*, double*, double*, int);
  double* tophat(int);
  double* gaussian(int);
  int build(long xdim, long ydim, double *image, Matrix&);
  int trace(long xdim, long ydim, double cntr,
	    long xCell, long yCell, int side,
	    double** rows, char* useGrid, Matrix&);

public:
  FVContour(Base*, FitsImage*, const char*, int, int, 
	    Method, int, int, const char*, FrScale::ColorScaleType, float,
	    float, Vector, InverseScale*);
  ~FVContour();

  void append(FitsImage*);
  void update(FitsImage*);
  void update(FitsImage*, InverseScale*);

  int method() {return method_;}
  const char* methodName();
  char* level() {return level_;}
  int numLevel() {return numLevel_;}
  int smooth() {return smooth_;}
  int colorScaleType() {return colorScaleType_;}
  float expo() {return expo_;}
  float clipMode() {return clipMode_;}
  Vector limits() {return limits_;}

  void setMethod(Method mm) {method_ = mm;}
  void setLevel(const char*);
  void setNumLevel(int num) {numLevel_ = num;}
  void setSmooth(int ss) {smooth_ = ss;}
  void setColorScaleType(FrScale::ColorScaleType tt) {colorScaleType_ = tt;}
  void setExpo(float xx) {expo_ = xx;}
  void setClipMode(float mm) {clipMode_ = mm;}
  void setLimits(const Vector& ll) {limits_ = ll;}
};

#endif
