package provide DS9 1.0

######
# Begin autogenerated taccle (version 1.3) routines.
# Although taccle itself is protected by the GNU Public License (GPL)
# all user-supplied functions are protected by their respective
# author's license.  See http://mini.net/tcl/taccle for other details.
######

namespace eval tilesend {
    variable yylval {}
    variable table
    variable rules
    variable token {}
    variable yycnt 0
    variable yyerr 0
    variable save_state 0

    namespace export yylex
}

proc tilesend::YYABORT {} {
    return -code return 1
}

proc tilesend::YYACCEPT {} {
    return -code return 0
}

proc tilesend::YYERROR {} {
    variable yyerr
    set yyerr 1
}

proc tilesend::yyclearin {} {
    variable token
    variable yycnt
    set token {}
    incr yycnt -1
}

proc tilesend::yyerror {s} {
    puts stderr $s
}

proc tilesend::setupvalues {stack pointer numsyms} {
    upvar 1 1 y
    set y {}
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        set y [lindex $stack $pointer]
        incr pointer
    }
}

proc tilesend::unsetupvalues {numsyms} {
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        unset y
    }
}

array set tilesend::table {
  6:0 reduce
  3:0,target 0
  7:0 reduce
  1:257 shift
  1:263,target 8
  8:0 reduce
  5:0,target 7
  1:258 shift
  0:259 shift
  1:260 shift
  0:261 shift
  7:0,target 4
  1:257,target 4
  0:262 goto
  1:261 shift
  0:0,target 1
  1:260,target 6
  0:261,target 2
  1:263 goto
  2:0,target 2
  4:0,target 5
  0:0 reduce
  6:0,target 6
  2:0 reduce
  8:0,target 3
  3:0 accept
  1:258,target 5
  0:259,target 1
  4:0 reduce
  5:0 reduce
  1:261,target 7
  0:262,target 3
}

array set tilesend::rules {
  0,l 264
  1,l 262
  2,l 262
  3,l 262
  4,l 263
  5,l 263
  6,l 263
  7,l 263
}

array set tilesend::rules {
  5,dc 1
  7,dc 1
  0,dc 1
  2,dc 1
  4,dc 1
  6,dc 1
  1,dc 0
  3,dc 2
}

array set tilesend::rules {
  5,line 23
  7,line 25
  2,line 18
  4,line 22
  6,line 24
  1,line 17
  3,line 19
}

array set tilesend::lr1_table {
  0 {{0 0 0} {1 0 0} {2 0 0} {3 0 0}}
  1 {{3 0 1} {4 0 0} {5 0 0} {6 0 0} {7 0 0}}
  2 {{2 0 1}}
  3 {{0 0 1}}
  0,trans {{259 1} {261 2} {262 3}}
  4 {{5 0 1}}
  5 {{7 0 1}}
  1,trans {{257 4} {258 5} {260 6} {261 7} {263 8}}
  6 {{6 0 1}}
  2,trans {}
  3,trans {}
  7 {{4 0 1}}
  4,trans {}
  8 {{3 0 2}}
  5,trans {}
  6,trans {}
  7,trans {}
  8,trans {}
}

array set tilesend::token_id_table {
  264,line 26
  262,title {}
  0,t 0
  0 {$}
  263,title {}
  264,title {}
  error,t 0
  error error
  258,line 9
  261,line 12
  error,line 15
  257 DIRECTION_
  257,t 0
  263,line 21
  258 GAP_
  258,t 0
  error,title {}
  260,t 0
  260 LAYOUT_
  259 GRID_
  259,t 0
  261,t 0
  261 MODE_
  262,t 1
  262 tilesend
  257,line 8
  263,t 1
  263 grid
  264,t 1
  264 start'
  260,line 11
  257,title DIRECTION
  259,line 10
  258,title GAP
  262,line 16
  260,title LAYOUT
  259,title GRID
  261,title MODE
}

proc tilesend::yyparse {} {
    variable yylval
    variable table
    variable rules
    variable token
    variable yycnt
    variable lr1_table
    variable token_id_table
    variable yyerr
    variable save_state

    set yycnt 0
    set state_stack {0}
    set value_stack {{}}
    set token ""
    set accepted 0
    set yyerr 0
    set save_state 0

    while {$accepted == 0} {
        set state [lindex $state_stack end]
        if {$token == ""} {
            set yylval ""
            set token [yylex]
            set buflval $yylval
	    if {$token>0} {
	        incr yycnt
            }
        }
        if {![info exists table($state:$token)] || $yyerr} {
	    if {!$yyerr} {
	        set save_state $state
	    }
            # pop off states until error token accepted
            while {[llength $state_stack] > 0 && \
                       ![info exists table($state:error)]} {
                set state_stack [lrange $state_stack 0 end-1]
                set value_stack [lrange $value_stack 0 \
                                       [expr {[llength $state_stack] - 1}]]
                set state [lindex $state_stack end]
            }
            if {[llength $state_stack] == 0} {
 
	        set rr { }
                if {[info exists lr1_table($save_state,trans)] && [llength $lr1_table($save_state,trans)] >= 1} {
                    foreach trans $lr1_table($save_state,trans) {
                        foreach {tok_id nextstate} $trans {
			    set ss $token_id_table($tok_id,title)
			    if {$ss != {}} {
			        append rr "$ss, "
                            }
                        }
                    }
                }
		set rr [string trimleft $rr { }]
		set rr [string trimright $rr {, }]
                yyerror "parse error, expecting: $rr"


                return 1
            }
            lappend state_stack [set state $table($state:error,target)]
            lappend value_stack {}
            # consume tokens until it finds an acceptable one
            while {![info exists table($state:$token)]} {
                if {$token == 0} {
                    yyerror "end of file while recovering from error"
                    return 1
                }
                set yylval {}
                set token [yylex]
                set buflval $yylval
            }
            continue
        }
        switch -- $table($state:$token) {
            shift {
                lappend state_stack $table($state:$token,target)
                lappend value_stack $buflval
                set token ""
            }
            reduce {
                set rule $table($state:$token,target)
                set ll $rules($rule,l)
                if {[info exists rules($rule,e)]} {
                    set dc $rules($rule,e)
                } else {
                    set dc $rules($rule,dc)
                }
                set stackpointer [expr {[llength $state_stack]-$dc}]
                setupvalues $value_stack $stackpointer $dc
                set _ $1
                set yylval [lindex $value_stack end]
                switch -- $rule {
                    1 { TileSendCmd }
                    2 { ProcessSendCmdGet tile mode }
                    4 { ProcessSendCmdGet tile grid,mode }
                    5 { ProcessSendCmdGet tile grid,dir }
                    6 { ProcessSendCmdGet2 tile grid,col grid,row }
                    7 { ProcessSendCmdGet tile grid,gap }
                }
                unsetupvalues $dc
                # pop off tokens from the stack if normal rule
                if {![info exists rules($rule,e)]} {
                    incr stackpointer -1
                    set state_stack [lrange $state_stack 0 $stackpointer]
                    set value_stack [lrange $value_stack 0 $stackpointer]
                }
                # now do the goto transition
                lappend state_stack $table([lindex $state_stack end]:$ll,target)
                lappend value_stack $_
            }
            accept {
                set accepted 1
            }
            goto -
            default {
                puts stderr "Internal parser error: illegal command $table($state:$token)"
                return 2
            }
        }
    }
    return 0
}

######
# end autogenerated taccle functions
######

proc tilesend::yyerror {msg} {
     variable yycnt
     variable yy_current_buffer
     variable index_

     ParserError $msg $yycnt $yy_current_buffer $index_
}
