#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Coffee Talk series:
# - Coffee Talk
# - Coffee Talk 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251023.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_EPISODE1='coffee-talk-1'
GAME_NAME_EPISODE1='Coffee Talk'

GAME_ID_EPISODE1_DEMO="${GAME_ID_EPISODE1}-demo"
GAME_NAME_EPISODE1_DEMO="$GAME_NAME_EPISODE1 (demo)"

GAME_ID_EPISODE2='coffee-talk-2'
GAME_NAME_EPISODE2='Coffee Talk Episode 2: Hibiscus & Butterfly'

ARCHIVE_BASE_EPISODE1_2_NAME='setup_coffee_talk_1.48_(56192).exe'
ARCHIVE_BASE_EPISODE1_2_MD5='480480ca243cb1371aa8160ae04f035d'
ARCHIVE_BASE_EPISODE1_2_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_2_SIZE='774504'
ARCHIVE_BASE_EPISODE1_2_VERSION='1.48-gog56192'
ARCHIVE_BASE_EPISODE1_2_URL='https://www.gog.com/game/coffee_talk'

ARCHIVE_BASE_EPISODE1_1_NAME='setup_coffee_talk_1.45_(48679).exe'
ARCHIVE_BASE_EPISODE1_1_MD5='d10f2ec8ced1716f90dbc4d940cf232f'
ARCHIVE_BASE_EPISODE1_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_1_SIZE='780000'
ARCHIVE_BASE_EPISODE1_1_VERSION='1.45-gog48679'

ARCHIVE_BASE_EPISODE1_0_NAME='setup_coffee_talk_1.0.39_(41435).exe'
ARCHIVE_BASE_EPISODE1_0_MD5='fd9a907261fce1069e1ffc37938e42d5'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_SIZE='910000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0.39-gog41435'

ARCHIVE_BASE_EPISODE1_DEMO_1_NAME='setup_coffee_talk_demo_1.0.40_(46157).exe'
ARCHIVE_BASE_EPISODE1_DEMO_1_MD5='c7d07aa9a162e1ad8d6cf527e8193bbe'
ARCHIVE_BASE_EPISODE1_DEMO_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_DEMO_1_SIZE='820000'
ARCHIVE_BASE_EPISODE1_DEMO_1_VERSION='1.0.40-gog46157'
ARCHIVE_BASE_EPISODE1_DEMO_1_URL='https://www.gog.com/game/coffee_talk_demo'

ARCHIVE_BASE_EPISODE1_DEMO_0_NAME='setup_coffee_talk_demo_0.92.59_(32093).exe'
ARCHIVE_BASE_EPISODE1_DEMO_0_MD5='107cb1767fb8033ad06b5baaeb54e159'
ARCHIVE_BASE_EPISODE1_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_DEMO_0_SIZE='650000'
ARCHIVE_BASE_EPISODE1_DEMO_0_VERSION='0.92.59-gog32093'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_coffee_talk_episode_2_hibiscus__butterfly_1.22_(67495).exe'
ARCHIVE_BASE_EPISODE2_0_MD5='4426e6896dc72ce47a355adcc1be3f68'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='696445'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.22-gog67495'
ARCHIVE_BASE_EPISODE2_0_URL='https://www.gog.com/game/coffee_talk_episode_2_hibiscus_butterfly'

UNITY3D_NAME_EPISODE1='coffeetalk'
UNITY3D_NAME_EPISODE2='cthb'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES_EPISODE1='
users/${USER}/AppData/LocalLow/Toge Productions/CoffeeTalk'
WINE_PERSISTENT_DIRECTORIES_EPISODE2='
users/${USER}/AppData/LocalLow/Toge Productions/CTHB'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ID_EPISODE1="$GAME_ID_EPISODE1"
PKG_BIN_ID_EPISODE1_DEMO="$GAME_ID_EPISODE1_DEMO"
PKG_BIN_ID_EPISODE2="$GAME_ID_EPISODE2"
PKG_BIN_ARCH_EPISODE1='32'
PKG_BIN_ARCH_EPISODE2='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'
## Easier upgrades from pre-20251023.3 packages
PKG_BIN_PROVIDES_EPISODE1='
coffee-talk'
PKG_BIN_PROVIDES_EPISODE1_DEMO='
coffee-talk-demo'

PKG_DATA_ID_EPISODE1="${GAME_ID_EPISODE1}-data"
PKG_DATA_ID_EPISODE1_DEMO="${GAME_ID_EPISODE1_DEMO}-data"
PKG_DATA_ID_EPISODE2="${GAME_ID_EPISODE2}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20251023.3 packages
PKG_DATA_PROVIDES_EPISODE1='
coffee-talk-data'
PKG_DATA_PROVIDES_EPISODE1_DEMO='
coffee-talk-data-demo'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
