# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
CENTOS_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(CENTOS_RELEASES),$(foreach a,x86_64 aarch64,centos-cloud-$r.$a))

$(foreach R,$(CENTOS_RELEASES),centos-cloud-$R.x86_64.run): centos-cloud-%.x86_64.run: $(MAKEFILE_LIST) | centos-cloud-%.x86_64.qcow2
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/centos" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_BIOS_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(CENTOS_RELEASES),centos-cloud-$R.aarch64.run): centos-cloud-%.aarch64.run: $(MAKEFILE_LIST) | centos-cloud-%.aarch64.qcow2 centos-cloud-%.aarch64.efi-code.img centos-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/centos" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(CENTOS_RELEASES),centos-cloud-$R.x86_64.qcow2): centos-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/centos/centos-cloud-%.x86_64.qcow2 centos-cloud-%.seed.iso
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_BIOS_CMDLINE,$@) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(foreach R,$(CENTOS_RELEASES),centos-cloud-$R.aarch64.qcow2): centos-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/centos/centos-cloud-%.aarch64.qcow2 centos-cloud-%.seed.iso centos-cloud-%.aarch64.efi-code.img centos-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/centos: | $(GARDEN_DL_DIR)
	mkdir -p $@

centos-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,centos-$*)
centos-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@

centos-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,CENTOS,$*),centos-$*,centos)
centos-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(CENTOS_RELEASES),$(foreach A,x86_64 aarch64,centos-cloud-$R.$A.qcow2 centos-cloud-$R.$A.run))
