#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# input-remapper - GUI for device specific keyboard mappings
# Copyright (C) 2025 sezanzeb <b8x45ygc9@mozmail.com>
#
# This file is part of input-remapper.
#
# input-remapper is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# input-remapper is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with input-remapper.  If not, see <https://www.gnu.org/licenses/>.

from __future__ import annotations

import asyncio
import random

from inputremapper.injection.macros.argument import ArgumentConfig
from inputremapper.injection.macros.task import Task


class WaitTask(Task):
    """Wait time in milliseconds."""

    argument_configs = [
        ArgumentConfig(
            name="time",
            position=0,
            types=[float, int],
        ),
        ArgumentConfig(
            name="max_time",
            position=1,
            types=[float, int, None],
            default=None,
        ),
    ]

    async def run(self, callback) -> None:
        time = self.get_argument("time").get_value()
        max_time = self.get_argument("max_time").get_value()

        if max_time is not None and max_time > time:
            time = random.uniform(time, max_time)

        await asyncio.sleep(time / 1000)
