package org.jboss.cache.commands;

import org.jboss.cache.InvocationContext;

/**
 * A type of command that can accept {@link org.jboss.cache.commands.Visitor}s, such as {@link org.jboss.cache.interceptors.base.CommandInterceptor}s.
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
public interface VisitableCommand extends ReplicableCommand
{
   /**
    * Accept a visitor, and return the result of accepting this visitor.
    *
    * @param ctx     invocation context
    * @param visitor visitor to accept
    * @return arbitrary return value
    * @throws Throwable in the event of problems
    */
   Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable;
}
