#!/bin/sh

set -e

TAR=../libjboss-web-services-java_$1.orig.tar.gz
DIR=libjboss-web-services-java-$1.orig
REVISION=`echo $1 | sed -e 's/.*svn//'`

# clean up the upstream tarball
mkdir $DIR
(cd $DIR;\
svn export -r $REVISION http://anonsvn.jboss.org/repos/jbossws/common/trunk/src/main/java jbossws-common;
svn export -r $REVISION http://anonsvn.jboss.org/repos/jbossws/spi/trunk/src/main/java jbossws-spi;
svn export -r $REVISION http://anonsvn.jboss.org/repos/jbossws/stack/native/trunk/src/main/java jbossws-native)

GZIP=--best tar -c -z -f $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
