/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CertificateFactory {
    private static final Class cl = Security.class;
    private static final Class[] GET_IMPL_PARAMS = new Class[]{String.class, String.class, String.class};
    private static final Class[] GET_IMPL_PARAMS2 = new Class[]{String.class, String.class, Provider.class};
    private static Method implMethod;
    private static Method implMethod2;
    private static Boolean implMethod2Set;
    private String type;
    private Provider provider;
    private CertificateFactorySpi certFacSpi;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        try {
            if (implMethod == null) {
                throw new CertificateException(string + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, new Object[]{string, "CertificateFactory", null});
            return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            CertificateException certificateException = new CertificateException(string + " not found");
            certificateException.initCause(illegalAccessException);
            throw certificateException;
        }
        catch (InvocationTargetException invocationTargetException) {
            CertificateException certificateException = new CertificateException(string + " not found");
            certificateException.initCause(invocationTargetException);
            throw certificateException;
        }
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            if (implMethod == null) {
                throw new CertificateException(string + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, new Object[]{string, "CertificateFactory", string2});
            return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            CertificateException certificateException = new CertificateException(string + " not found");
            certificateException.initCause(illegalAccessException);
            throw certificateException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable != null && throwable instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)throwable;
            }
            CertificateException certificateException = new CertificateException(string + " not found");
            certificateException.initCause(invocationTargetException);
            throw certificateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final CertificateFactory getInstance(String string, Provider provider) throws CertificateException {
        Object[] objectArray;
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        if (!implMethod2Set.booleanValue()) {
            objectArray = implMethod2Set;
            // MONITORENTER : implMethod2Set
            if (!implMethod2Set.booleanValue()) {
                implMethod2 = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Method method = null;
                        try {
                            method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS2);
                            if (method != null) {
                                method.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        return method;
                    }
                });
                implMethod2Set = new Boolean(true);
            }
            // MONITOREXIT : objectArray
        }
        if (implMethod2 == null) {
            throw new CertificateException(string + " not found");
        }
        try {
            objectArray = (Object[])implMethod2.invoke(null, new Object[]{string, "CertificateFactory", provider});
            return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            CertificateException certificateException = new CertificateException(string + " not found");
            certificateException.initCause(illegalAccessException);
            throw certificateException;
        }
        catch (InvocationTargetException invocationTargetException) {
            CertificateException certificateException = new CertificateException(string + " not found");
            certificateException.initCause(invocationTargetException);
            throw certificateException;
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Iterator getCertPathEncodings() {
        return this.certFacSpi.engineGetCertPathEncodings();
    }

    public final CertPath generateCertPath(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream);
    }

    public final CertPath generateCertPath(InputStream inputStream, String string) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream, string);
    }

    public final CertPath generateCertPath(List list) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(list);
    }

    public final Collection generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }

    static {
        implMethod2Set = new Boolean(false);
        implMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS);
                    if (method != null) {
                        method.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }
}

