/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWQTCHATHISTORYWIDGET_H
#define OWQTCHATHISTORYWIDGET_H

#include <imwrapper/EnumIMProtocol.h>

#include <QtCore/QTime>
#include <QtCore/QUrl>
#include <QtGui/QTextBrowser>
#include <QtWebKit/QtWebKit>

class QtChatTheme;

/**
 * Implements the chat text zone with a custom context menu.
 *
 * @author Nicolas Couturier
 * @author Mathieu Stute
 * @author Xavier Desjardins
 */
class QtChatHistoryWidget : public QWebView 
{
	Q_OBJECT
public:
	
	void clear();
	
	QtChatHistoryWidget(QWidget * parent);

	~QtChatHistoryWidget();

	void setTheme(const QString& themeDir , const QString& variant = "");

	void insertMessage(const QString & contactId, const QString & senderName, const QString & str, const QTime & time);
	
	void insertMessage2(const QString & contactId, const QString & senderName, const QString & message, const QTime & time);
	
	void insertStatusMessage(const QString & statusMessage, const QTime& time);
	
	void setProtocol(EnumIMProtocol::IMProtocol newProtocol) {
		_protocol = newProtocol;
	}

	void saveHistoryAsHtml();

	void setTranslate(bool val)
	{
		_translate = val;
	}
	/**
	 * Overloaded to implement avatar loading
	 */
	//virtual QVariant loadResource(int type, const QUrl& url);

	void setAvatarPixmap(const QString& name, const QPixmap& pixmap);

private Q_SLOTS:

	/**
	 * An URL has been clicked we must open a web browser
	 *
	 * @param link the clicked url
	 */
	void urlClicked(const QUrl & link);
	
public Q_SLOTS:
	void scrollToBottom();
	
	void translationFinishedSlot(const QVariant  & , const QVariant  &, const QVariant  &, const QVariant  &, const QVariant  &);

private:
	void updateHtml();

	QString _data;
	
	EnumIMProtocol::IMProtocol _protocol;

	QString _lastSenderName;

	QTime _lastMessageTime;

	QMap <QString, QString> _avatarMap;

	QMap <QUrl, QPixmap> _scaledAvatarCache;

	QtChatTheme* _theme;
	
	bool _translate;
};

#endif	//OWQTCHATHISTORYWIDGET_H
